﻿using System;

/// <summary>
///     Przykład użycia atrybutu zdefiniowanego przez użytkownika
/// </summary>
[
    Tracker("CR-0001",
            "jakaś poprawka błędu",
            EngineerId = "Józef",
            ChangeDate = "4.07.2008")
]
class SomeProgram
{
    static void Main(string[] args)
    {
        SomeProgram sp = new SomeProgram();
    }
}

[
    AttributeUsage(AttributeTargets.All,
                   AllowMultiple = true,
                   Inherited = true)
]
class TrackerAttribute : Attribute
{
    public string ProblemId;
    public string EngineerId;
    private string fixDescription;
    private DateTime changeDate;

    public string FixDescription
    {
        get
        {
            return fixDescription;
        }
        set
        {
            fixDescription = value;
        }
    }

    public string ChangeDate
    {
        get
        {
            return changeDate.ToString("d");
        }
        set
        {
            changeDate = DateTime.Parse(value);
        }
    }

    public TrackerAttribute()
    {
        ProblemId = "NIEPRZYDZIELONY";
        EngineerId = "Nieznany projektant";
        FixDescription = "Brak opisu";
        ChangeDate = "1.01.2009";
    }

    public TrackerAttribute(string problemId, string fixDescription)
    {
        ProblemId = problemId;
        EngineerId = "Nieznany projektant";
        FixDescription = fixDescription;
        ChangeDate = "1.01.2009";
    }
}
